//* ======================================================================== 
//*  The information contained herein is the exclusive property of Sunplus 
//*  Technology Co. And shall not be distributed, reproduced, or disclosed 
//*  in whole in part without prior written permission.
//*       (C) Copyright 2005 Sunplus Technology Co. All rights reserved.
//*  The entire notice above must be reproduced on all authorized copies
//*=========================================================================
//*=========================================================================
//*  Filename: DVR1800_Dec_Conv.asm
//*  Function Description: The bridge between the old AP and the new kernal interface.
//*  Author:  sharonyu
//*  Date:    2009.03.31
//*  Email:   sharonyu@generalplus.com
//*
//*  Revision history:
//*-------------------------------------------------------------------
//*  YYYY-MM-DD-INDEX      Modified By         Description
//*     2009.03.31           sharonyu			debug
//*-------------------------------------------------------------------

OVERLAP_A1800_RAM_BLOCK:  .SECTION        .ORAM
.public cwPackageSize
.var cwPackageSize;

.external R_SACM_A1800_DECODE_IN_LENGTH
.external R_SACM_A1800_Decode_In_PTR
.external R_SACM_A1800_Decode_Out_PTR
.external _A1800_Dec_Init
.external _A1800_Decode

.define C_DECODE_WORK_MEM_SIZE 343//353//453

OVERLAP_A1800_DM_BLOCK: .SECTION .ORAM // 20090331 added by sharonyu
.public R_SACM_A1800_DECODE_WORK_MEM
R_SACM_A1800_DECODE_WORK_MEM:
.dw  C_DECODE_WORK_MEM_SIZE	dup(?)


SACM_A1800_ROM_BLOCK:  .SECTION        .CODE

.public F_A1800_Dec_Init
// extern void A1800_Dec_Init(int bitrate);
F_A1800_Dec_Init:    .proc

	push bp to [sp];
	
	//r3 = [R_SACM_A1800_Decode_In_PTR+1];	// segment of R_SACM_DVR1800_Decode_In_PTR
	r3 = 0;
	
.ifndef ISA20
	r1 = r3 LSL 4;
	r1 = r1 LSL 4;
	r1 = r1 LSL 2;
	sr |= r1;
.else
	DS = r3;
.endif

	r2 = [R_SACM_A1800_Decode_In_PTR];
	r1 = D:[r2];
	r2 += 1;
	r3 += 0, carry;
	[R_SACM_A1800_Decode_In_PTR] = r2;
	//[R_SACM_DVR1800_Decode_In_PTR+1] = r3;
	
	push r1 to [sp];
	// void DVR1800_Dec_Init(bitrate);
	// return cwPackageSize (320 words pcm samples -> encode -> cwPackageSize words bistream)
	call _A1800_Dec_Init;
	sp += 1;
	
	r1 = 0;
	[cwPackageSize] = r1;
	
	r1 = 1;
	[R_SACM_A1800_DECODE_IN_LENGTH] = r1;
	
	pop bp from [sp];
	retf;
	
.endp


.public F_A1800_Decode
// #ifdef __pointer32
// 	typedef short * LPSHORT;
// 	typedef unsigned short PSHORT;
//	extern int A1800_Decode(LPSHORT inptr, PSHORT outptr);
// #else 
// 	typedef unsigned long LPSHORT;
// 	typedef short *PSHORT;
//	extern int A1800_Decode(unsigned short inptr, unsigned short inptr_seg, PSHORT outptr);
// #endif

F_A1800_Decode:   .proc   

	push bp to [sp];
	
	r2 = [R_SACM_A1800_Decode_In_PTR];
	//r3 = [R_SACM_A1800_Decode_In_PTR+1];	// segment of R_SACM_A1800_Decode_In_PTR
	r3 = 0;
	r4 = [R_SACM_A1800_Decode_Out_PTR];
	push r2, r4 to [sp];
	// int DVR1800_Decode(int *inptr, short *outptr);
	// return cwPackageSize (320 words pcm samples -> encode -> cwPackageSize words bistream)
	call _A1800_Decode;
	sp += 3;
	
	[cwPackageSize] = r1;
	
	r2 = [R_SACM_A1800_Decode_In_PTR];
	//r3 = [R_SACM_A1800_Decode_In_PTR+1];
	r2 += [cwPackageSize];
	r3 += 0, carry;
	[R_SACM_A1800_Decode_In_PTR] = r2;
	//[R_SACM_A1800_Decode_In_PTR+1] = r3;

	pop bp from [sp];
	retf;

.endp